<?php

namespace App\Form;

use App\Service\UniqueIdentifierGenerator;
use Symfony\Component\Form\AbstractType;
use Symfony\Component\Form\Extension\Core\Type\TextType;
use Symfony\Component\Form\FormBuilderInterface;
use Symfony\Component\OptionsResolver\OptionsResolver;
use Symfony\Component\Validator\Constraints\NotBlank;
use Symfony\Component\Validator\Constraints\Type;

class RetirementFormType extends AbstractType
{
    public function buildForm(FormBuilderInterface $builder, array $options): void
    {
        $builder
            ->add('vintage_id', TextType::class, [
                'constraints' => [
                    new NotBlank(['message' => 'Please enter the vintage ID']),
                    new Type(['type' => 'string', 'message' => 'The vintage ID should be a string']),
                ],
            ])
            ->add('quantity_grams', TextType::class, [
                'constraints' => [
                    new NotBlank(['message' => 'Please enter the quantity in grams']),
                    new Type(['type' => 'string', 'message' => 'The quantity should be a string']),
                ],
            ])
            ->add('sell_order_id', TextType::class, [
                'required' => false,
            ])
            ->add('expected_price_cents', TextType::class, [
                'required' => false,
            ])
        ;
    }

    public function configureOptions(OptionsResolver $resolver): void
    {
        $resolver->setDefaults([
            // Configure your form options here
        ]);
    }
}
